<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employees()
    {
        return $this->hasMany('App\Models\Person');
    }

    public function owner()
    {
        return $this->belongsTo('App\Models\Person');
    }

}